'use client';

import { motion } from 'framer-motion';
import { useLanguage } from '@/contexts/language-context';
import { Globe, ShieldCheck, Cpu, Users, AreaChart, Landmark, Star } from 'lucide-react';
import React from 'react';

const iconMap: { [key: string]: React.ElementType } = {
  Globe,
  ShieldCheck,
  Cpu,
  Users,
  AreaChart,
  Landmark,
};

const cardColors = [
  { gradient: 'from-blue-500 to-cyan-400', bg: 'bg-blue-500/10', glow: 'shadow-blue-500/50' },
  { gradient: 'from-emerald-500 to-green-400', bg: 'bg-emerald-500/10', glow: 'shadow-emerald-500/50' },
  { gradient: 'from-purple-500 to-violet-400', bg: 'bg-purple-500/10', glow: 'shadow-purple-500/50' },
  { gradient: 'from-amber-500 to-yellow-400', bg: 'bg-amber-500/10', glow: 'shadow-amber-500/50' },
  { gradient: 'from-rose-500 to-pink-400', bg: 'bg-rose-500/10', glow: 'shadow-rose-500/50' },
  { gradient: 'from-indigo-500 to-sky-400', bg: 'bg-indigo-500/10', glow: 'shadow-indigo-500/50' },
];

export default function WhyPartnersChooseUs() {
  const { content } = useLanguage();
  const { whyPartnersChooseUs } = content;

  return (
    <section className="relative overflow-hidden bg-background py-20 sm:py-24">
      {/* Background Grid */}
      <div className="absolute inset-0 z-0">
        <div className="absolute inset-0 bg-[radial-gradient(#e2e8f0_1px,transparent_1px)] [background-size:32px_32px] dark:bg-[radial-gradient(#334155_1px,transparent_1px)]"></div>
        <div className="absolute inset-0 bg-gradient-to-b from-background via-background/90 to-background"></div>
      </div>
      
      <div className="container relative z-10 mx-auto px-4">
        {/* Header */}
        <motion.div
          initial={{ opacity: 0, y: -20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
          className="mx-auto mb-16 max-w-3xl text-center"
        >
          <div className="mb-4 inline-flex items-center gap-2 rounded-full border border-primary/10 bg-primary/5 px-4 py-2">
            <Star className="h-5 w-5 text-accent" />
            <p className="text-sm font-semibold text-primary">{whyPartnersChooseUs.badge}</p>
          </div>
          <h2 className="text-4xl font-bold tracking-tight text-primary sm:text-5xl">
            {whyPartnersChooseUs.title}
          </h2>
          <p className="mt-6 text-lg leading-8 text-muted-foreground">
            {whyPartnersChooseUs.subtitle}
          </p>
        </motion.div>

        {/* Features Grid */}
        <div className="grid grid-cols-1 gap-8 sm:grid-cols-2 lg:grid-cols-3">
          {whyPartnersChooseUs.items.map((item, index) => {
            const Icon = iconMap[item.icon];
            const color = cardColors[index % cardColors.length];

            return (
              <motion.div
                key={index}
                initial={{ opacity: 0, scale: 0.9 }}
                whileInView={{ opacity: 1, scale: 1 }}
                viewport={{ once: true }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
                className="group relative"
              >
                <div className={`absolute -inset-px rounded-2xl bg-gradient-to-r ${color.gradient} opacity-0 blur transition-opacity duration-500 group-hover:opacity-70`} />
                <div className={`relative h-full overflow-hidden rounded-2xl border border-border ${color.bg} p-8 transition-all duration-300 group-hover:bg-transparent`}>
                  <div className={`absolute -right-12 -top-12 h-32 w-32 rounded-full bg-gradient-to-r ${color.gradient} opacity-10 blur-2xl transition-opacity duration-500 group-hover:opacity-20`} />
                  
                  <div className="relative">
                    <div className={`mb-6 inline-block rounded-xl bg-gradient-to-r ${color.gradient} p-4 shadow-lg ${color.glow}`}>
                      {Icon && <Icon className="h-8 w-8 text-white" />}
                    </div>
                    <h3 className="mb-2 text-xl font-bold text-primary">
                      {item.title}
                    </h3>
                    <p className="text-muted-foreground">
                      {item.description}
                    </p>
                  </div>
                </div>
              </motion.div>
            );
          })}
        </div>
      </div>
    </section>
  );
}
